
USE AccountsProduction
GO


--FixDoubleEntitySpecificAssignmentsQuery

PRINT '
FixDoubleEntitySpecificAssignmentsQuery'

DELETE
FROM dbo.[NH_AccountCategorisationOverride]
WHERE [Id] IN (
		SELECT aco1.[Id]
		FROM dbo.[NH_AccountCategorisationOverride] aco1
		INNER JOIN dbo.[StructureEntity] s ON aco1.[EntityId] = s.[Id]
		INNER JOIN dbo.[NH_AccountCategorisationOverride] aco2 ON aco1.[VersionedTemplateId] = aco2.[VersionedTemplateId]
			AND aco1.[AccountId] = aco2.[AccountId]
			AND aco1.[RootCategoryId] = aco2.[RootCategoryId]
			AND aco1.[EntityId] = aco2.[EntityId]
			AND aco1.[Credit] = aco2.[Credit]
		INNER JOIN dbo.[VersionedNominalCategory] nc1 ON aco1.[VersionedTemplateId] = nc1.[VersionedTemplateID]
			AND aco1.VersionedChartId = nc1.[ParentChartVersionedID]
			AND aco1.[NewCategoryId] = nc1.[VersionedID]
		WHERE aco1.[Id] != aco2.[Id]
		)

GO

--FixDraftTemplatesSomehowParentTemplatesQuery

PRINT '
FixDraftTemplatesSomehowParentTemplatesQuery'

UPDATE pvt1
SET pvt1.[Deleted] = 1
FROM dbo.[Private_VersionedTemplate] pvt1
INNER JOIN dbo.[Private_VersionedTemplate] pvt2 ON pvt1.[VersionedTemplateID] = pvt2.[ParentVersionedTemplateID]
	AND pvt2.[ParentVersionedTemplateID] IS NOT NULL
	AND pvt1.[Published] = 0
	AND pvt1.[Deleted] = 0

GO

--FixLocalEditTypeQuery

PRINT '
FixLocalEditTypeQuery'

DECLARE @VersionedTables TABLE (
	Id INT NOT NULL PRIMARY KEY IDENTITY(1, 1)
	,TableName NVARCHAR(128)
	)

IF (OBJECT_ID('tempdb..#TemplatesToFix') IS NOT NULL)
BEGIN
	DROP TABLE #TemplatesToFix
END

CREATE TABLE #TemplatesToFix (
	Id INT NOT NULL PRIMARY KEY IDENTITY(1, 1)
	,TemplateID UNIQUEIDENTIFIER
	)

DECLARE @RowsToProcess INT
DECLARE @CurrentRow INT
DECLARE @CurrentTableName NVARCHAR(128)

INSERT INTO @VersionedTables
SELECT t.name
FROM sys.columns c
INNER JOIN sys.tables t ON c.object_id = t.object_id
WHERE c.name = 'LocalEditType'

SET @RowsToProcess = @@ROWCOUNT
SET @CurrentRow = 0

WHILE @CurrentRow < @RowsToProcess
BEGIN
	SET @CurrentRow = @CurrentRow + 1

	SELECT @CurrentTableName = TableName
	FROM @VersionedTables
	WHERE Id = @CurrentRow

	DECLARE @sql NVARCHAR(MAX) = N'  
              INSERT INTO #TemplatesToFix
                     SELECT DISTINCT a.VersionedTemplateID
                           FROM ' + @CurrentTableName + ' a
                     INNER JOIN VersionedTemplate t
						ON t.VersionedTemplateID = a.VersionedTemplateID
					INNER JOIN ' + @CurrentTableName + ' b
						ON b.VersionedTemplateID = t.ParentVersionedTemplateID
						AND b.VersionedID = a.VersionedID
					WHERE a.LocalEditType = 2
					AND t.Published = 0
					AND NOT EXISTS (SELECT TemplateID FROM #TemplatesToFix);'

	EXEC (@sql);
END

DECLARE @RowsToProcessTemplates INT
DECLARE @Current_Row INT
DECLARE @CurrentTemplateId UNIQUEIDENTIFIER

SELECT @RowsToProcessTemplates = COUNT(*)
FROM #TemplatesToFix

SET @Current_Row = 0

WHILE @Current_Row < @RowsToProcessTemplates
BEGIN
	SET @Current_Row = @Current_Row + 1

	SELECT @CurrentTemplateId = TemplateID
	FROM #TemplatesToFix
	WHERE Id = @Current_Row

	EXEC FixTemplateLocalEditType @VersionedTemplateID = @CurrentTemplateId
END

GO


--FixOrphanedEntityAssignmentsQuery

PRINT '
FixOrphanedEntityAssignmentsQuery'

DELETE FROM dbo.[NH_AccountCategorisationOverride]
WHERE [OldCategoryId] IS NULL
	AND [NewCategoryId] IS NULL

GO

--FixOrphanedVersionedTemplateDataValuesQuery

PRINT '
FixOrphanedVersionedTemplateDataValuesQuery'

DELETE vtdv
FROM dbo.[VersionedTemplateDataValue] vtdv
LEFT JOIN dbo.[Private_VersionedTemplate] vt ON vtdv.[VersionedTemplateID] = vt.[VersionedTemplateID]
WHERE vt.[Name] IS NULL

GO

--FixSameAssignmentsInMasterAndEntityQuery

PRINT '
FixSameAssignmentsInMasterAndEntityQuery'

DECLARE @TemplateId UNIQUEIDENTIFIER
DECLARE @TemplatesWithFP TABLE (
	Id INT NOT NULL PRIMARY KEY IDENTITY(1, 1)
	,VersionedTemplateId UNIQUEIDENTIFIER
	)
DECLARE @EntityAssignments TABLE (
	Id INT NOT NULL PRIMARY KEY IDENTITY(1, 1)
	,AssignmentId UNIQUEIDENTIFIER
	)
DECLARE @RowsToProcess INT
DECLARE @CurrentRow INT

INSERT INTO @TemplatesWithFP
SELECT VersionedTemplateID
FROM VersionedTemplate vt
INNER JOIN Period p ON vt.ParentPeriodID = p.ID
INNER JOIN Client c ON c.ID = p.ClientID

SET @RowsToProcess = @@ROWCOUNT
SET @CurrentRow = 0

WHILE @CurrentRow < @RowsToProcess
BEGIN
	SET @CurrentRow = @CurrentRow + 1

	SELECT @TemplateId = VersionedTemplateId
	FROM @TemplatesWithFP
	WHERE Id = @CurrentRow;

	INSERT INTO @EntityAssignments
	SELECT o.Id
	FROM dbo.[NH_AccountCategorisationOverride] o
	INNER JOIN dbo.[VersionedNominalCategoryNominalSubCodeLink] acl ON acl.[VersionedTemplateID] = o.[VersionedTemplateId]
		AND acl.[ChildVersionedID] = o.[AccountId]
		AND acl.[ParentVersionedID] = o.[NewCategoryId]
		AND acl.[Relationship] = o.[Credit]
	LEFT JOIN dbo.[VersionedNominalSubCode] a ON a.[VersionedTemplateID] = o.[VersionedTemplateId]
		AND a.[VersionedID] = o.[AccountId]
	LEFT JOIN dbo.[VersionedNominalCategory] c ON c.[VersionedTemplateID] = o.[VersionedTemplateId]
		AND c.[VersionedID] = o.[NewCategoryId]
	LEFT JOIN dbo.[VersionedNominalCategory] oc ON oc.[VersionedTemplateID] = o.[VersionedTemplateId]
		AND oc.[VersionedID] = o.[OldCategoryId]
	LEFT JOIN dbo.[VersionedNominalCategory] rc ON rc.[VersionedTemplateID] = o.[VersionedTemplateId]
		AND rc.[VersionedID] = o.[RootCategoryId]
	INNER JOIN VersionedTemplate t ON t.[VersionedTemplateID] = o.[VersionedTemplateId]
	INNER JOIN dbo.[Period] p ON p.[ID] = t.[ParentPeriodID]
	LEFT JOIN dbo.[Structure] s ON s.[PeriodId] = p.[ID]
	LEFT JOIN dbo.[StructureEntity] e ON e.[StructureId] = s.[Id]
		AND e.[Id] = o.[EntityId]
	WHERE o.[VersionedTemplateId] = @TemplateId
		AND oc.[NominalCategoryCodename] = c.[NominalCategoryCodename]
	ORDER BY e.[Code]
		,rc.[NominalCategoryCodename]
		,oc.[NominalCategoryCodename]
		,c.[NominalCategoryCodename]
END

DECLARE @AssignmentRowsToProcess INT
DECLARE @Current_Row INT
DECLARE @EntityAssignmentId UNIQUEIDENTIFIER

SELECT @AssignmentRowsToProcess = Count(*)
FROM @EntityAssignments

SET @Current_Row = 0

WHILE @Current_Row < @AssignmentRowsToProcess
BEGIN
	SET @Current_Row = @Current_Row + 1

	SELECT @EntityAssignmentId = AssignmentId
	FROM @EntityAssignments
	WHERE Id = @Current_Row;

	DELETE
	FROM NH_AccountCategorisationOverride
	WHERE Id = @EntityAssignmentId
END

GO


--FixSetMissingComparativePeriodRoundingAccountsQuery

PRINT 'FixSetMissingComparativePeriodRoundingAccountsQuery'

UPDATE cp
SET [RoundingAccountId] = (
                 SELECT TOP 1 [VersionedID]
                 FROM dbo.[VersionedNominalSubCode]
                 WHERE [VersionedTemplateID] = vt.[VersionedTemplateID]
                 ORDER BY [SubCode]
                 )
FROM dbo.[NH_ComparativePeriod] cp
INNER JOIN dbo.[Period] p ON p.[ID] = cp.[PeriodId]
INNER JOIN VersionedTemplate vt ON vt.[ParentPeriodID] = p.[ID]
LEFT JOIN dbo.[VersionedNominalSubCode] acc ON acc.[VersionedID] = cp.[RoundingAccountId]
         AND acc.[VersionedTemplateID] = vt.[VersionedTemplateID]
WHERE acc.[VersionedID] IS NULL

GO


--FixSetMissingCurrentPeriodRoundingAccountsQuery

PRINT '
FixSetMissingCurrentPeriodRoundingAccountsQuery'

INSERT [dbo].[VersionedNominalSubCodeChartLink] (
	[VersionedTemplateID]
	,[VersionedID]
	,[ParentVersionedID]
	,[ChildVersionedID]
	,[Relationship]
	)
SELECT vc.[VersionedTemplateID]
	,NEWID()
	,(
		SELECT TOP 1 [VersionedID]
		FROM dbo.[VersionedNominalSubCode]
		WHERE [VersionedTemplateID] = vc.[VersionedTemplateID]
		ORDER BY [SubCode]
		)
	,vc.[VersionedID]
	,3
FROM [dbo].[VersionedChart] vc
LEFT JOIN [dbo].[VersionedNominalSubCodeChartLink] link ON vc.[VersionedTemplateID] = link.[VersionedTemplateID]
	AND link.[Relationship] = 3
WHERE link.[VersionedTemplateID] IS NULL

GO

--FixSetMissingSuspenseAccountsQuery

PRINT 'FixSetMissingSuspenseAccountsQuery'

INSERT [dbo].[VersionedNominalSubCodeChartLink] (
	[VersionedTemplateID]
	,[VersionedID]
	,[ParentVersionedID]
	,[ChildVersionedID]
	,[Relationship]
	)
SELECT vc.[VersionedTemplateID]
	,NEWID()
	,(
		SELECT TOP 1 [VersionedID]
		FROM dbo.[VersionedNominalSubCode]
		WHERE [VersionedTemplateID] = vc.[VersionedTemplateID]
		ORDER BY [SubCode]
		)
	,vc.[VersionedID]
	,2
FROM [dbo].[VersionedChart] vc
LEFT JOIN [dbo].[VersionedNominalSubCodeChartLink] link ON vc.[VersionedTemplateID] = link.[VersionedTemplateID]
	AND link.[Relationship] = 2
WHERE link.[VersionedTemplateID] IS NULL

GO


--FixEAssignmentsNoRCWithNewCategoryQuery

PRINT '
FixEAssignmentsNoRCWithNewCategoryQuery'

DECLARE @ChildCategory UNIQUEIDENTIFIER
DECLARE @TemplateId UNIQUEIDENTIFIER
DECLARE @CategoriesWithRoot TABLE (
	ChildCategory UNIQUEIDENTIFIER
	,RootCategory UNIQUEIDENTIFIER
	,TemplateID UNIQUEIDENTIFIER
	)
DECLARE @EntityAssignments TABLE (
	Id INT NOT NULL PRIMARY KEY IDENTITY(1, 1)
	,NewCategoryId UNIQUEIDENTIFIER
	,VersionedTemplateId UNIQUEIDENTIFIER
	)
DECLARE @RowsToProcess INT
DECLARE @CurrentRow INT

INSERT INTO @EntityAssignments
SELECT DISTINCT NewCategoryId
	,VersionedTemplateId
FROM NH_AccountCategorisationOverride
WHERE RootCategoryId IS NULL
AND NewCategoryId IS NOT NULL

SET @RowsToProcess = @@ROWCOUNT
SET @CurrentRow = 0

WHILE @CurrentRow < @RowsToProcess
BEGIN
	SET @CurrentRow = @CurrentRow + 1

	SELECT @ChildCategory = NewCategoryId
		,@TemplateId = VersionedTemplateId
	FROM @EntityAssignments
	WHERE Id = @CurrentRow;

	WITH ParentCategories
	AS (
		SELECT Cat.ParentVersionedID
			,Cat.ChildVersionedID
		FROM VersionedNominalCategoryNominalCategoryLink Cat
		WHERE Cat.ChildVersionedID = @ChildCategory
			AND Cat.VersionedTemplateID = @TemplateId
		
		UNION ALL
		
		SELECT Cat1.ParentVersionedID
			,Cat1.ChildVersionedID
		FROM VersionedNominalCategoryNominalCategoryLink Cat1
		INNER JOIN ParentCategories ParentCat ON Cat1.ChildVersionedID = ParentCat.ParentVersionedID
		WHERE Cat1.VersionedTemplateID = @TemplateId
		)
	INSERT INTO @CategoriesWithRoot
	SELECT @ChildCategory
		,ParentVersionedID
		,@TemplateId
	FROM ParentCategories
	WHERE ParentVersionedID NOT IN (
			SELECT DISTINCT Cat.ChildVersionedID
			FROM VersionedNominalCategoryNominalCategoryLink Cat
			WHERE Cat.VersionedTemplateID = @TemplateId
			)

	INSERT INTO @CategoriesWithRoot
	SELECT @ChildCategory
		,Cat.VersionedID
		,@TemplateId
	FROM VersionedNominalCategory Cat
	WHERE Cat.VersionedTemplateID = @TemplateId
		AND Cat.VersionedID = @ChildCategory
		AND Cat.VersionedID NOT IN (
			SELECT DISTINCT CatsLink.ChildVersionedID
			FROM VersionedNominalCategoryNominalCategoryLink CatsLink
			WHERE CatsLink.VersionedTemplateID = @TemplateId
			)
END

UPDATE a
SET a.RootCategoryId = r.RootCategory
FROM NH_AccountCategorisationOverride a
INNER JOIN @CategoriesWithRoot r ON r.TemplateID = a.VersionedTemplateId
	AND r.ChildCategory = a.NewCategoryId
WHERE a.RootCategoryId IS NULL



GO

--FixEAssignmentsNoRCWithOldCategoryQuery

PRINT '
FixEAssignmentsNoRCWithOldCategoryQuery'

DECLARE @ChildCategory UNIQUEIDENTIFIER
DECLARE @TemplateId UNIQUEIDENTIFIER
DECLARE @CategoriesWithRoot TABLE (
	ChildCategory UNIQUEIDENTIFIER
	,RootCategory UNIQUEIDENTIFIER
	,TemplateID UNIQUEIDENTIFIER
	)
DECLARE @EntityAssignments TABLE (
	Id INT NOT NULL PRIMARY KEY IDENTITY(1, 1)
	,OldCategoryId UNIQUEIDENTIFIER
	,VersionedTemplateId UNIQUEIDENTIFIER
	)
DECLARE @RowsToProcess INT
DECLARE @CurrentRow INT

INSERT INTO @EntityAssignments
SELECT DISTINCT OldCategoryId
	,VersionedTemplateId
FROM NH_AccountCategorisationOverride
WHERE RootCategoryId IS NULL 
AND OldCategoryId IS NOT NULL
AND NewCategoryId IS NULL

SET @RowsToProcess = @@ROWCOUNT
SET @CurrentRow = 0

WHILE @CurrentRow < @RowsToProcess
BEGIN
	SET @CurrentRow = @CurrentRow + 1

	SELECT @ChildCategory = OldCategoryId
		,@TemplateId = VersionedTemplateId
	FROM @EntityAssignments
	WHERE Id = @CurrentRow;

	WITH ParentCategories
	AS (
		SELECT Cat.ParentVersionedID
			,Cat.ChildVersionedID
		FROM VersionedNominalCategoryNominalCategoryLink Cat
		WHERE Cat.ChildVersionedID = @ChildCategory
			AND Cat.VersionedTemplateID = @TemplateId
		
		UNION ALL
		
		SELECT Cat1.ParentVersionedID
			,Cat1.ChildVersionedID
		FROM VersionedNominalCategoryNominalCategoryLink Cat1
		INNER JOIN ParentCategories ParentCat ON Cat1.ChildVersionedID = ParentCat.ParentVersionedID
		WHERE Cat1.VersionedTemplateID = @TemplateId
		)
	INSERT INTO @CategoriesWithRoot
	SELECT @ChildCategory
		,ParentVersionedID
		,@TemplateId
	FROM ParentCategories
	WHERE ParentVersionedID NOT IN (
			SELECT DISTINCT Cat.ChildVersionedID
			FROM VersionedNominalCategoryNominalCategoryLink Cat
			WHERE Cat.VersionedTemplateID = @TemplateId
			)

	INSERT INTO @CategoriesWithRoot
	SELECT @ChildCategory
		,Cat.VersionedID
		,@TemplateId
	FROM VersionedNominalCategory Cat
	WHERE Cat.VersionedTemplateID = @TemplateId
		AND Cat.VersionedID = @ChildCategory
		AND Cat.VersionedID NOT IN (
			SELECT DISTINCT CatsLink.ChildVersionedID
			FROM VersionedNominalCategoryNominalCategoryLink CatsLink
			WHERE CatsLink.VersionedTemplateID = @TemplateId
			)
END

UPDATE a
SET a.RootCategoryId = r.RootCategory
FROM NH_AccountCategorisationOverride a
INNER JOIN @CategoriesWithRoot r ON r.TemplateID = a.VersionedTemplateId
	AND r.ChildCategory = a.OldCategoryId
WHERE a.RootCategoryId IS NULL

GO

--FixEAssignmentsRCWithNewCategoryQuery

PRINT '
FixEAssignmentsRCWithNewCategoryQuery'

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE [id] = OBJECT_ID(N'[dbo].[tmpCategoriesWithRoots]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP Table [dbo].[tmpCategoriesWithRoots]


CREATE TABLE tmpCategoriesWithRoots  (
	VersionedId UNIQUEIDENTIFIER
	,RootCategory UNIQUEIDENTIFIER
	,VersionedTemplateID UNIQUEIDENTIFIER
	,VersionedChartID UNIQUEIDENTIFIER
	)

INSERT INTO tmpCategoriesWithRoots
SELECT  vnc.[VersionedID]
	,vnc.[VersionedID]
	,vnc.[VersionedTemplateID]
	,vnc.[ParentChartVersionedID]
FROM dbo.[VersionedNominalCategory] vnc
LEFT JOIN dbo.[VersionedNominalCategoryNominalCategoryLink] vncl ON vnc.[VersionedTemplateID] = vncl.[VersionedTemplateID]
	AND vnc.[VersionedID] = vncl.[ChildVersionedID]
INNER JOIN VersionedTemplate vt ON vnc.[VersionedTemplateID] = vt.[VersionedTemplateID]
WHERE vt.[Published] = 0
	AND vncl.[ChildVersionedID] IS NULL;

WITH Cat
AS (
	SELECT DISTINCT vncl.[ParentVersionedID]
		,vncl.[ChildVersionedID]
		,cr.[RootCategory]
		,vncl.[VersionedTemplateID]
		,cr.[VersionedChartID]
	FROM dbo.[VersionedNominalCategoryNominalCategoryLink] vncl
	INNER JOIN tmpCategoriesWithRoots cr ON vncl.[ParentVersionedID] = cr.[VersionedId]
	INNER JOIN VersionedTemplate vt ON vncl.[VersionedTemplateID] = vt.[VersionedTemplateID]
	
	UNION ALL
	
	SELECT vncl2.[ParentVersionedID]
		,vncl2.[ChildVersionedID]
		,c.[RootCategory]
		,c.[VersionedTemplateID]
		,c.[VersionedChartID]
	FROM dbo.[VersionedNominalCategoryNominalCategoryLink] vncl2
	INNER JOIN Cat c ON c.[ChildVersionedID] = vncl2.[ParentVersionedID]
		AND c.[VersionedTemplateID] = vncl2.[VersionedTemplateID]
	)
INSERT INTO tmpCategoriesWithRoots
SELECT DISTINCT c.[ChildVersionedID]
	,c.[RootCategory]
	,c.[VersionedTemplateID]
	,c.[VersionedChartID]
FROM Cat c

UPDATE nh
SET nh.[RootCategoryId] = cr.[RootCategory]
	,nh.[VersionedChartId] = cr.[VersionedChartID]
FROM dbo.[NH_AccountCategorisationOverride] nh
INNER JOIN tmpCategoriesWithRoots cr ON cr.[VersionedTemplateID] = nh.[VersionedTemplateId]
	AND cr.[VersionedId] = nh.[NewCategoryId]
WHERE nh.[RootCategoryId] IN (
		SELECT nh2.[RootCategoryId]
		FROM dbo.[NH_AccountCategorisationOverride] nh2
		LEFT JOIN dbo.[VersionedNominalCategory] vnc ON vnc.[VersionedTemplateID] = nh2.[VersionedTemplateId]
			AND vnc.[VersionedID] = nh2.[RootCategoryId]
		WHERE vnc.[VersionedID] IS NULL
		)


IF EXISTS (SELECT * FROM dbo.sysobjects WHERE [id] = OBJECT_ID(N'[dbo].[tmpCategoriesWithRoots]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP Table [dbo].[tmpCategoriesWithRoots]



--FixEAssignmentsRCWithOldCategoryQuery

PRINT '
FixEAssignmentsRCWithOldCategoryQuery'

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE [id] = OBJECT_ID(N'[dbo].[tmpCategoriesWithRoots]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP Table [dbo].[tmpCategoriesWithRoots]


CREATE TABLE tmpCategoriesWithRoots  (
	VersionedId UNIQUEIDENTIFIER
	,RootCategory UNIQUEIDENTIFIER
	,VersionedTemplateID UNIQUEIDENTIFIER
	,VersionedChartID UNIQUEIDENTIFIER
	)



INSERT INTO tmpCategoriesWithRoots
SELECT DISTINCT vnc.[VersionedID]
	,vnc.[VersionedID]
	,vnc.[VersionedTemplateID]
	,vnc.[ParentChartVersionedID]
FROM dbo.[VersionedNominalCategory] vnc
LEFT JOIN dbo.[VersionedNominalCategoryNominalCategoryLink] vncl ON vnc.[VersionedTemplateID] = vncl.[VersionedTemplateID]
	AND vnc.[VersionedID] = vncl.[ChildVersionedID]
INNER JOIN VersionedTemplate vt ON vnc.[VersionedTemplateID] = vt.[VersionedTemplateID]
WHERE vt.[Published] = 0
	AND vncl.[ChildVersionedID] IS NULL;

WITH Cat
AS (
	SELECT DISTINCT vncl.[ParentVersionedID]
		,vncl.[ChildVersionedID]
		,cr.[RootCategory]
		,vncl.[VersionedTemplateID]
		,cr.[VersionedChartID]
	FROM dbo.[VersionedNominalCategoryNominalCategoryLink] vncl
	INNER JOIN tmpCategoriesWithRoots cr ON vncl.[ParentVersionedID] = cr.[VersionedId]
	INNER JOIN VersionedTemplate vt ON vncl.[VersionedTemplateID] = vt.[VersionedTemplateID]
	
	UNION ALL
	
	SELECT vncl2.[ParentVersionedID]
		,vncl2.[ChildVersionedID]
		,c.[RootCategory]
		,c.[VersionedTemplateID]
		,c.[VersionedChartID]
	FROM dbo.[VersionedNominalCategoryNominalCategoryLink] vncl2
	INNER JOIN Cat c ON c.[ChildVersionedID] = vncl2.[ParentVersionedID]
		AND c.[VersionedTemplateID] = vncl2.[VersionedTemplateID]
	)
INSERT INTO tmpCategoriesWithRoots
SELECT DISTINCT c.[ChildVersionedID]
	,c.[RootCategory]
	,c.[VersionedTemplateID]
	,c.[VersionedChartID]
FROM Cat c

UPDATE nh
SET nh.[RootCategoryId] = cr.[RootCategory]
	,nh.[VersionedChartId] = cr.[VersionedChartID]
FROM dbo.[NH_AccountCategorisationOverride] nh
INNER JOIN tmpCategoriesWithRoots cr ON cr.[VersionedTemplateID] = nh.[VersionedTemplateId]
	AND cr.[VersionedId] = nh.[OldCategoryId]
WHERE nh.[RootCategoryId] IN (
		SELECT nh2.[RootCategoryId]
		FROM dbo.[NH_AccountCategorisationOverride] nh2
		LEFT JOIN dbo.[VersionedNominalCategory] vnc ON vnc.[VersionedTemplateID] = nh2.[VersionedTemplateId]
			AND vnc.[VersionedID] = nh2.[RootCategoryId]
		WHERE vnc.[VersionedID] IS NULL
		)


IF EXISTS (SELECT * FROM dbo.sysobjects WHERE [id] = OBJECT_ID(N'[dbo].[tmpCategoriesWithRoots]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP Table [dbo].[tmpCategoriesWithRoots]

GO


--FixDoubleMasterAssignmentsQuery

PRINT 'FixDoubleMasterAssignmentsQuery'

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE [id] = OBJECT_ID(N'[dbo].[tmpCategoriesWithRoots1]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP Table [dbo].[tmpCategoriesWithRoots1]

CREATE TABLE dbo.tmpCategoriesWithRoots1
(VersionedId UNIQUEIDENTIFIER
	,RootCategory UNIQUEIDENTIFIER
	,VersionedTemplateId UNIQUEIDENTIFIER)


INSERT INTO tmpCategoriesWithRoots1
SELECT DISTINCT vnc.[VersionedID]
	,vnc.[VersionedID]
	,vnc.[VersionedTemplateID]
FROM dbo.[VersionedNominalCategory] vnc
LEFT JOIN dbo.[VersionedNominalCategoryNominalCategoryLink] vncl ON vnc.[VersionedTemplateID] = vncl.[VersionedTemplateID]
	AND vnc.[VersionedID] = vncl.[ChildVersionedID]
INNER JOIN VersionedTemplate vt ON vnc.[VersionedTemplateID] = vt.[VersionedTemplateID]
WHERE vt.[Published] = 0
	AND vncl.[ChildVersionedID] IS NULL;

WITH Cat
AS (
	SELECT DISTINCT vncl.[ParentVersionedID]
		,vncl.[ChildVersionedID]
		,cr.[RootCategory]
		,vncl.[VersionedTemplateID]
	FROM dbo.[VersionedNominalCategoryNominalCategoryLink] vncl
	INNER JOIN tmpCategoriesWithRoots1 cr ON vncl.[ParentVersionedID] = cr.[VersionedId]
	INNER JOIN VersionedTemplate vt ON vncl.[VersionedTemplateID] = vt.[VersionedTemplateID]
	
	UNION ALL
	
	SELECT vncl2.[ParentVersionedID]
		,vncl2.[ChildVersionedID]
		,c.[RootCategory]
		,c.[VersionedTemplateID]
	FROM dbo.[VersionedNominalCategoryNominalCategoryLink] vncl2
	INNER JOIN Cat c ON c.[ChildVersionedID] = vncl2.[ParentVersionedID]
		AND c.[VersionedTemplateID] = vncl2.[VersionedTemplateID]
	)
INSERT INTO tmpCategoriesWithRoots1
SELECT DISTINCT c.[ChildVersionedID]
	,c.[RootCategory]
	,c.[VersionedTemplateID]
FROM Cat c



DECLARE RC_Cursor CURSOR LOCAL STATIC FORWARD_ONLY READ_ONLY
FOR

SELECT DISTINCT RootCategory
	,VersionedTemplateId
FROM tmpCategoriesWithRoots1

DECLARE @VersionedId UNIQUEIDENTIFIER
DECLARE @RootCategoryID UNIQUEIDENTIFIER
DECLARE @VersionedTemplate UNIQUEIDENTIFIER


IF EXISTS (SELECT * FROM dbo.sysobjects WHERE [id]  = OBJECT_ID(N'[dbo].[tmpDuplicateAssignments]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP Table [dbo].[tmpDuplicateAssignments]

CREATE TABLE dbo.tmpDuplicateAssignments
(VersionedId UNIQUEIDENTIFIER
	,rank_ INT)


SET NOCOUNT ON;

OPEN RC_Cursor

FETCH NEXT
FROM RC_Cursor
INTO @RootCategoryID
	,@VersionedTemplate

WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO tmpDuplicateAssignments
	SELECT vnscl.[VersionedID]
		,ROW_NUMBER() OVER (
			PARTITION BY vnscl.[VersionedTemplateID]
			,vnscl.[ChildVersionedID]
			,vnscl.[Relationship] ORDER BY vnscl.[ParentVersionedID] DESC
			)
	FROM dbo.[VersionedNominalCategoryNominalSubCodeLink] vnscl
	INNER JOIN tmpCategoriesWithRoots1 c ON vnscl.[ParentVersionedID] = c.[VersionedId]
		AND vnscl.[VersionedTemplateID] = c.[VersionedTemplateId]
	INNER JOIN dbo.[VersionedNominalCategoryNominalSubCodeLink] vnscl2 ON vnscl.[VersionedTemplateID] = vnscl2.[VersionedTemplateID]
		AND vnscl.[ChildVersionedID] = vnscl2.[ChildVersionedID]
	INNER JOIN tmpCategoriesWithRoots1 c2 ON vnscl2.[ParentVersionedID] = c2.[VersionedId]
		AND vnscl2.[VersionedTemplateID] = c2.[VersionedTemplateId]
	WHERE vnscl.[VersionedTemplateID] = @VersionedTemplate
		AND vnscl2.[VersionedTemplateID] = @VersionedTemplate
		AND c.[RootCategory] = @RootCategoryID
		AND c2.[RootCategory] = @RootCategoryID
		AND vnscl.[ParentVersionedID] != vnscl2.[ParentVersionedID]
		AND vnscl.[Relationship] = vnscl2.[Relationship]

	FETCH NEXT
	FROM RC_Cursor
	INTO @RootCategoryID
		,@VersionedTemplate
END

CLOSE RC_Cursor

DEALLOCATE RC_Cursor

SET NOCOUNT OFF;

DELETE vnscl
FROM dbo.[VersionedNominalCategoryNominalSubCodeLink] vnscl
WHERE vnscl.[VersionedID] IN (
		SELECT VersionedID
		FROM tmpDuplicateAssignments
		WHERE rank_ > 1
		)


IF EXISTS (SELECT * FROM dbo.sysobjects WHERE [id]  = OBJECT_ID(N'[dbo].[tmpDuplicateAssignments]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP Table [dbo].[tmpDuplicateAssignments]	

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE [id]  = OBJECT_ID(N'[dbo].[tmpCategoriesWithRoots1]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP Table [dbo].[tmpCategoriesWithRoots1]

GO